/*
 * Decompiled with CFR 0.152.
 */
package shiffman.box2d;

import java.lang.reflect.Method;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.Manifold;
import org.jbox2d.dynamics.contacts.Contact;
import processing.core.PApplet;

public class Box2DContactListener
implements ContactListener {
    PApplet parent;
    Method beginMethod;
    Method endMethod;
    Method postMethod;
    Method preMethod;

    Box2DContactListener(PApplet p) {
        this.parent = p;
        try {
            this.beginMethod = this.parent.getClass().getMethod("beginContact", Contact.class);
        }
        catch (Exception e) {
            System.out.println("You are missing the beginContact() method. " + e);
        }
        try {
            this.endMethod = this.parent.getClass().getMethod("endContact", Contact.class);
        }
        catch (Exception e) {
            System.out.println("You are missing the endContact() method. " + e);
        }
        try {
            this.postMethod = this.parent.getClass().getMethod("postSolve", Contact.class, ContactImpulse.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.preMethod = this.parent.getClass().getMethod("preSolve", Contact.class, Manifold.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void beginContact(Contact c) {
        if (this.beginMethod != null) {
            try {
                this.beginMethod.invoke((Object)this.parent, c);
            }
            catch (Exception e) {
                System.out.println("Could not invoke the \"beginContact()\" method for some reason.");
                e.printStackTrace();
                this.beginMethod = null;
            }
        }
    }

    public void endContact(Contact c) {
        if (this.endMethod != null) {
            try {
                this.endMethod.invoke((Object)this.parent, c);
            }
            catch (Exception e) {
                System.out.println("Could not invoke the \"removeContact()\" method for some reason.");
                e.printStackTrace();
                this.endMethod = null;
            }
        }
    }

    public void postSolve(Contact c, ContactImpulse ci) {
        if (this.postMethod != null) {
            try {
                this.postMethod.invoke((Object)this.parent, c, ci);
            }
            catch (Exception e) {
                System.out.println("Could not invoke the \"postSolve()\" method for some reason.");
                e.printStackTrace();
                this.postMethod = null;
            }
        }
    }

    public void preSolve(Contact c, Manifold m) {
        if (this.preMethod != null) {
            try {
                this.preMethod.invoke((Object)this.parent, c, m);
            }
            catch (Exception e) {
                System.out.println("Could not invoke the \"preSolve()\" method for some reason.");
                e.printStackTrace();
                this.preMethod = null;
            }
        }
    }
}

