/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import processing.core.PApplet;
import shiffman.box2d.Box2DProcessing;

public class box2d_LEARNING
extends PApplet {
    ArrayList<Box> boxes;
    ArrayList<Circle> circles;
    ArrayList<Boundary> boundaries;
    Box2DProcessing box2d;
    boolean text = true;
    boolean phase2 = false;
    float gravW = 0.0f;
    float gravH = -20.0f;
    int gravPhases = 1;

    public void setup() {
        this.box2d = new Box2DProcessing((PApplet)this);
        this.box2d.createWorld();
        this.phase2 = false;
        this.boxes = new ArrayList();
        this.circles = new ArrayList();
        this.boundaries = new ArrayList();
    }

    public void draw() {
        this.background(255);
        if (this.gravPhases == 1) {
            this.gravW = 0.0f;
            this.gravH = -30.0f;
        } else if (this.gravPhases == 2) {
            this.gravW = 0.0f;
            this.gravH = 30.0f;
        } else if (this.gravPhases == 3) {
            this.gravW = -30.0f;
            this.gravH = 0.0f;
        } else if (this.gravPhases == 4) {
            this.gravW = 30.0f;
            this.gravH = 0.0f;
        }
        this.box2d.setGravity(this.gravW, this.gravH);
        if (this.text) {
            this.textSize(21.0f);
            this.fill(0);
            this.textAlign(3);
            this.text("Press and/or Hold Left Mouse Button to Make Shapes", this.width / 2, 30.0f);
            this.text("Press Right Mouse Button to Make Barriers", this.width / 2, 60.0f);
            this.text("Press Space Bar to Shift Gravity", this.width / 2, 90.0f);
        }
        this.box2d.step();
        if (this.mousePressed && this.mouseButton == 37) {
            Box p = new Box(this.mouseX, this.mouseY);
            this.boxes.add(p);
            this.phase2 = true;
            Circle c = new Circle(this.mouseX, this.mouseY);
            this.circles.add(c);
        }
        for (Box b : this.boxes) {
            b.display();
        }
        for (Circle cr : this.circles) {
            cr.display();
        }
        for (Boundary by : this.boundaries) {
            by.display();
        }
    }

    public void mousePressed() {
        if (this.mouseButton == 39) {
            Boundary by = new Boundary(this.mouseX, this.mouseY, 4.0f, 4.0f, 0.0f);
            this.boundaries.add(by);
        }
    }

    public void keyReleased() {
        if (this.key == ' ' && this.gravPhases < 4) {
            ++this.gravPhases;
        } else if (this.gravPhases >= 4) {
            this.gravPhases = 1;
        }
        box2d_LEARNING.println((int)this.gravPhases);
    }

    public void settings() {
        this.size(720, 720);
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--stop-color=#cccccc", "box2d_LEARNING"};
        if (passedArgs != null) {
            PApplet.main((String[])box2d_LEARNING.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Boundary {
        float x;
        float y;
        float w;
        float h;
        Body b;

        Boundary(float x_, float y_, float w_, float h_, float a) {
            this.x = x_;
            this.y = y_;
            this.w = w_;
            this.h = h_;
            PolygonShape sd = new PolygonShape();
            float box2dW = box2d_LEARNING.this.box2d.scalarPixelsToWorld(this.w / 2.0f);
            float box2dH = box2d_LEARNING.this.box2d.scalarPixelsToWorld(this.h / 2.0f);
            sd.setAsBox(box2dW, box2dH);
            BodyDef bd = new BodyDef();
            bd.type = BodyType.STATIC;
            bd.angle = a;
            bd.position.set(box2d_LEARNING.this.box2d.coordPixelsToWorld(this.x, this.y));
            this.b = box2d_LEARNING.this.box2d.createBody(bd);
            this.b.createFixture((Shape)sd, 1.0f);
        }

        public void display() {
            box2d_LEARNING.this.fill(0);
            box2d_LEARNING.this.stroke(0);
            box2d_LEARNING.this.strokeWeight(1.0f);
            box2d_LEARNING.this.rectMode(3);
            float a = this.b.getAngle();
            box2d_LEARNING.this.pushMatrix();
            box2d_LEARNING.this.translate(this.x, this.y);
            box2d_LEARNING.this.rotate(-a);
            box2d_LEARNING.this.rect(0.0f, 0.0f, this.w, this.h);
            box2d_LEARNING.this.popMatrix();
        }

        public void killBody() {
            box2d_LEARNING.this.box2d.destroyBody(this.b);
        }
    }

    class Box {
        Body body;
        float randomR;
        float randomG;
        float randomB;
        float x;
        float y;
        float w;
        float h;

        Box(float x_, float y_) {
            this.randomR = box2d_LEARNING.this.random(0.0f, 255.0f);
            this.randomG = box2d_LEARNING.this.random(0.0f, 255.0f);
            this.randomB = box2d_LEARNING.this.random(0.0f, 255.0f);
            this.x = x_;
            this.y = y_;
            this.w = 16.0f;
            this.h = 16.0f;
            BodyDef bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(box2d_LEARNING.this.box2d.coordPixelsToWorld(this.x, this.y));
            this.body = box2d_LEARNING.this.box2d.createBody(bd);
            PolygonShape ps = new PolygonShape();
            float box2dw = box2d_LEARNING.this.box2d.scalarPixelsToWorld(this.w / 2.0f);
            float box2dh = box2d_LEARNING.this.box2d.scalarPixelsToWorld(this.h / 2.0f);
            ps.setAsBox(box2dw, box2dh);
            FixtureDef fd = new FixtureDef();
            fd.shape = ps;
            fd.density = box2d_LEARNING.this.random(3.0f, 50.0f);
            fd.friction = 5.0f;
            fd.restitution = 1.2f;
            this.body.createFixture(fd);
        }

        public void display() {
            Vec2 pos = box2d_LEARNING.this.box2d.getBodyPixelCoord(this.body);
            float a = this.body.getAngle();
            box2d_LEARNING.this.pushMatrix();
            box2d_LEARNING.this.translate(pos.x, pos.y);
            box2d_LEARNING.this.rotate(-a);
            box2d_LEARNING.this.fill(this.randomR, this.randomG, this.randomB);
            box2d_LEARNING.this.noStroke();
            box2d_LEARNING.this.rectMode(3);
            box2d_LEARNING.this.rect(0.0f, 0.0f, this.w, this.h);
            box2d_LEARNING.this.popMatrix();
        }
    }

    class Circle {
        Body circle;
        float w = 250.0f;
        float h = 50.0f;
        float r = 9.0f;
        float x;
        float y;

        Circle(float x_, float y_) {
            this.x = x_;
            this.y = y_;
            this.makeCircle(new Vec2(this.x, this.y));
        }

        public void killBody() {
            box2d_LEARNING.this.box2d.destroyBody(this.circle);
        }

        public boolean done() {
            Vec2 pos = box2d_LEARNING.this.box2d.getBodyPixelCoord(this.circle);
            if (pos.y < (float)box2d_LEARNING.this.height + this.w * this.h) {
                this.killBody();
                return true;
            }
            return false;
        }

        public void display() {
            Vec2 pos = box2d_LEARNING.this.box2d.getBodyPixelCoord(this.circle);
            float a = this.circle.getAngle();
            box2d_LEARNING.this.pushMatrix();
            box2d_LEARNING.this.translate(pos.x, pos.y);
            box2d_LEARNING.this.rotate(-a);
            box2d_LEARNING.this.fill(155.0f, 10.0f, 10.0f);
            box2d_LEARNING.this.noStroke();
            box2d_LEARNING.this.rectMode(3);
            box2d_LEARNING.this.ellipse(0.0f, this.h / 2.0f, this.r * 2.0f, this.r * 2.0f);
            box2d_LEARNING.this.popMatrix();
        }

        public void makeCircle(Vec2 center) {
            BodyDef bigCir = new BodyDef();
            bigCir.type = BodyType.DYNAMIC;
            bigCir.position.set(box2d_LEARNING.this.box2d.coordPixelsToWorld(center));
            this.circle = box2d_LEARNING.this.box2d.createBody(bigCir);
            CircleShape circleShape = new CircleShape();
            circleShape.m_radius = box2d_LEARNING.this.box2d.scalarPixelsToWorld(this.r);
            circleShape.m_p.set(this.x, this.y);
            FixtureDef crFix = new FixtureDef();
            crFix.shape = circleShape;
            crFix.density = -58.0f;
            crFix.friction = 5.0f;
            crFix.restitution = 1.5f;
            this.circle.createFixture(crFix);
        }
    }
}

