import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import shiffman.box2d.*; 
import org.jbox2d.collision.shapes.*; 
import org.jbox2d.common.*; 
import org.jbox2d.dynamics.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class sketch_001_Box2dProcessing extends PApplet {








// A list for all of our rectangles
ArrayList<Box> boxes;
ArrayList<Circle> circles;
ArrayList<Boundary> boundaries;
Box2DProcessing box2d;

boolean text = true;
boolean phase2 = false;

float gravW = 0;
float gravH = -20;

int gravPhases = 1;

public void setup() {
  
  

 
  
  box2d = new Box2DProcessing(this);
  box2d.createWorld();
  
  
  
  phase2 = false;
  

  // Create ArrayLists
  boxes = new ArrayList<Box>();
  circles = new ArrayList<Circle>();
 
  boundaries = new ArrayList<Boundary>();
  //Add circle///
  
 // Circle c = new Circle(width/2, height/2);
  //circles.add(c);
   
    
}

public void draw() {
  background(255);
  
  if (gravPhases == 1){
      gravW = 0;
      gravH = -30;
  } else if (gravPhases == 2){
       gravW = 0;
       gravH = 30;
  } else if (gravPhases == 3){
       gravW = -30;
       gravH = 0;
  } else if (gravPhases == 4){
 
       gravW = 30;
       gravH = 0;
  }
      
      
    
    
  
  
  
  box2d.setGravity(gravW,gravH);
  
  if (text == true) {
 textSize (21);
 fill (0);
 textAlign(CENTER);
  text ("Press and/or Hold Left Mouse Button to Make Shapes", width/2, 30);
  text ("Press Right Mouse Button to Make Barriers", width/2,  60);
  text ("Press Space Bar to Shift Gravity", width/2, 90);
  }
  
  
  box2d.step();
  


  // When the mouse is clicked, add a new Box object
  if (mousePressed && (mouseButton == LEFT)) {
    Box p = new Box(mouseX,mouseY);
    boxes.add(p);
    phase2 = true;
    
  Circle c = new Circle(mouseX, mouseY);
  circles.add(c);
  }

 
  // Display all the boxes
  for (Box b: boxes) {
    b.display();
  }
  for (Circle cr: circles) {
    cr.display();
}

  for (Boundary by: boundaries) {
    by.display();
  

  }


  
}


public void mousePressed() {
  if (mouseButton == RIGHT) {
     Boundary by = new Boundary(mouseX, mouseY,4,4,0);
     boundaries.add(by);
  }
  
  
}


public void keyReleased() {
  if (key == ' ' && gravPhases <4) {
     gravPhases = gravPhases +1;
  } else if (gravPhases  >= 4) {
    gravPhases =1;
  }
  println (gravPhases); 
  
}
 
// A rectangular box
class Box  {

 Body body;
 float randomR = (random(0,255));
 float randomG = (random(0,255));
 float randomB = (random(0,255));
 
  float x,y;
  float w,h;

  // Constructor
  Box(float x_, float y_) {
    x = x_;
    y = y_;
    
    w = 16;
    h = 16;
    
    //Step 1: Define Body
    BodyDef bd = new BodyDef();
    bd.type = BodyType.DYNAMIC;
    bd.position.set(box2d.coordPixelsToWorld(x,y));
    
    //Step 2: Create Body
    body = box2d.createBody(bd);
    
    //Step 3: create Shape.
    PolygonShape ps = new PolygonShape();
    float box2dw = box2d.scalarPixelsToWorld(w/2);
    float box2dh = box2d.scalarPixelsToWorld(h/2);
    ps.setAsBox(box2dw, box2dh);
    
    //Step 4: create Fixture
    FixtureDef fd = new FixtureDef();
    fd.shape = ps;
    //Parameters for physics
    fd.density = random(3,50);
    fd.friction = 5;
    fd.restitution = 1.2f;
    
    
    //Step 5: Attach shape to boxy with fixture
    body.createFixture(fd);

  }

  // Drawing the box
  public void display() {
    Vec2 pos = box2d.getBodyPixelCoord(body);
    float a = body.getAngle();
    
    pushMatrix();
    translate(pos.x,pos.y);
    rotate(-a);
    fill(randomR, randomG, randomB);
    noStroke();
    rectMode(CENTER);
    rect(0,0,w,h);
    popMatrix();
  }
}
// A rectangular box
class Circle  {

 Body circle;
 
 
  float w;
  float h;
  float r;
  
  float x;
  float y;

  // Constructor
  Circle(float x_, float y_) {
    w = 250;
    h = 50;
    r = 9;
    
    x = x_;
    y = y_;
    
    makeCircle(new Vec2(x,y));
  }
  
  
    // This function removes the particle from the box2d world
  public void killBody() {
    box2d.destroyBody(circle);
  }
  
///////// Is the particle ready for deletion?////////////////////////////
  public boolean done() {
    // Let's find the screen position of the particle
    Vec2 pos = box2d.getBodyPixelCoord(circle);
    // Is it off the bottom of the screen?
    //if (pos.y > height+w*h || pos.y < 0-w*h || pos.x > width+w*h || pos.x < 0+w*h) {
     if (pos.y < height+w*h){
      killBody();
      return true;
    }
    return false;
  }
  
    



  // Drawing the Circle
  public void display() {
    Vec2 pos = box2d.getBodyPixelCoord(circle);
    float a = circle.getAngle();
    
    pushMatrix();
    translate(pos.x,pos.y);
    rotate(-a);
    fill(155,10,10);
    noStroke();
    rectMode(CENTER);
    ellipse(0, h/2, r*2, r*2);
    popMatrix();
  }
  
  public void makeCircle(Vec2 center) {
  /////// Drawing theCIRCLE//////////
    //Step 1: Define Body
    BodyDef bigCir = new BodyDef();
    bigCir.type = BodyType.DYNAMIC;
    bigCir.position.set(box2d.coordPixelsToWorld(center));
    
    //Step 2: Create Body
    circle = box2d.createBody(bigCir);
    
    //Step 3: create Shape.
    CircleShape circleShape = new CircleShape();
    circleShape.m_radius = box2d.scalarPixelsToWorld(r);
    //Vec2 offsett = new Vec2(0,0);
    circleShape.m_p.set(x,y);
    
    
    
    //Step 4: create Fixture
    FixtureDef crFix = new FixtureDef();
    crFix.shape = circleShape;
    //Parameters for physics
    crFix.density = -58;
    crFix.friction = 5;
    crFix.restitution = 1.5f;
    
    
    //Step 5: Attach shape to boxy with fixture
    circle.createFixture(crFix);

  
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
}
// The Nature of Code
// <http://www.shiffman.net/teaching/nature>
// Spring 2012
// Box2DProcessing example

// A fixed boundary class (now incorporates angle)


class Boundary {

  // A boundary is a simple rectangle with x,y,width,and height
  float x;
  float y;
  float w;
  float h;
  // But we also have to make a body for box2d to know about it
  Body b;

 Boundary(float x_,float y_, float w_, float h_, float a) {
    x = x_;
    y = y_;
    w = w_;
    h = h_;

    // Define the polygon
    PolygonShape sd = new PolygonShape();
    // Figure out the box2d coordinates
    float box2dW = box2d.scalarPixelsToWorld(w/2);
    float box2dH = box2d.scalarPixelsToWorld(h/2);
    // We're just a box
    sd.setAsBox(box2dW, box2dH);


    // Create the body
    BodyDef bd = new BodyDef();
   
    bd.type = BodyType.STATIC;

    bd.angle = a;
    bd.position.set(box2d.coordPixelsToWorld(x,y));
    b = box2d.createBody(bd);
    
    // Attached the shape to the body using a Fixture
    b.createFixture(sd,1);
  }

  // Draw the boundary, if it were at an angle we'd have to do something fancier
  public void display() {
    fill(0);
    stroke(0);
    strokeWeight(1);
    rectMode(CENTER);

    float a = b.getAngle();

    pushMatrix();
    translate(x,y);
    rotate(-a);
    rect(0,0,w,h);
    popMatrix();
  }
  
    // This function removes the particle from the box2d world
  public void killBody() {
    box2d.destroyBody(b);
  }

}
  public void settings() {  size(720,720);  smooth(); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#030303", "--stop-color=#2B90FA", "sketch_001_Box2dProcessing" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
