// A rectangular box
class Circle  {

 Body circle;
 
 
  float w;
  float h;
  float r;
  
  float x;
  float y;

  // Constructor
  Circle(float x_, float y_) {
    w = 250;
    h = 50;
    r = 9;
    
    x = x_;
    y = y_;
    
    makeCircle(new Vec2(x,y));
  }
  
  
    // This function removes the particle from the box2d world
  void killBody() {
    box2d.destroyBody(circle);
  }
  
///////// Is the particle ready for deletion?////////////////////////////
  boolean done() {
    // Let's find the screen position of the particle
    Vec2 pos = box2d.getBodyPixelCoord(circle);
    // Is it off the bottom of the screen?
    //if (pos.y > height+w*h || pos.y < 0-w*h || pos.x > width+w*h || pos.x < 0+w*h) {
     if (pos.y < height+w*h){
      killBody();
      return true;
    }
    return false;
  }
  
    



  // Drawing the Circle
  void display() {
    Vec2 pos = box2d.getBodyPixelCoord(circle);
    float a = circle.getAngle();
    
    pushMatrix();
    translate(pos.x,pos.y);
    rotate(-a);
    fill(155,10,10);
    noStroke();
    rectMode(CENTER);
    ellipse(0, h/2, r*2, r*2);
    popMatrix();
  }
  
  void makeCircle(Vec2 center) {
  /////// Drawing theCIRCLE//////////
    //Step 1: Define Body
    BodyDef bigCir = new BodyDef();
    bigCir.type = BodyType.DYNAMIC;
    bigCir.position.set(box2d.coordPixelsToWorld(center));
    
    //Step 2: Create Body
    circle = box2d.createBody(bigCir);
    
    //Step 3: create Shape.
    CircleShape circleShape = new CircleShape();
    circleShape.m_radius = box2d.scalarPixelsToWorld(r);
    //Vec2 offsett = new Vec2(0,0);
    circleShape.m_p.set(x,y);
    
    
    
    //Step 4: create Fixture
    FixtureDef crFix = new FixtureDef();
    crFix.shape = circleShape;
    //Parameters for physics
    crFix.density = -58;
    crFix.friction = 5;
    crFix.restitution = 1.5;
    
    
    //Step 5: Attach shape to boxy with fixture
    circle.createFixture(crFix);

  
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
}