// A rectangular box
class Box  {

 Body body;
 float randomR = (random(0,255));
 float randomG = (random(0,255));
 float randomB = (random(0,255));
 
  float x,y;
  float w,h;

  // Constructor
  Box(float x_, float y_) {
    x = x_;
    y = y_;
    
    w = 16;
    h = 16;
    
    //Step 1: Define Body
    BodyDef bd = new BodyDef();
    bd.type = BodyType.DYNAMIC;
    bd.position.set(box2d.coordPixelsToWorld(x,y));
    
    //Step 2: Create Body
    body = box2d.createBody(bd);
    
    //Step 3: create Shape.
    PolygonShape ps = new PolygonShape();
    float box2dw = box2d.scalarPixelsToWorld(w/2);
    float box2dh = box2d.scalarPixelsToWorld(h/2);
    ps.setAsBox(box2dw, box2dh);
    
    //Step 4: create Fixture
    FixtureDef fd = new FixtureDef();
    fd.shape = ps;
    //Parameters for physics
    fd.density = random(3,50);
    fd.friction = 5;
    fd.restitution = 1.2;
    
    
    //Step 5: Attach shape to boxy with fixture
    body.createFixture(fd);

  }

  // Drawing the box
  void display() {
    Vec2 pos = box2d.getBodyPixelCoord(body);
    float a = body.getAngle();
    
    pushMatrix();
    translate(pos.x,pos.y);
    rotate(-a);
    fill(randomR, randomG, randomB);
    noStroke();
    rectMode(CENTER);
    rect(0,0,w,h);
    popMatrix();
  }
}