/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import org.jbox2d.pooling.IDynamicStack;

public abstract class MutableStack<E>
implements IDynamicStack<E> {
    private E[] stack = null;
    private int index = 0;
    private int size;

    public MutableStack(int argInitSize) {
        this.extendStack(argInitSize);
    }

    private void extendStack(int argSize) {
        E[] newStack = this.newArray(argSize);
        if (this.stack != null) {
            System.arraycopy(this.stack, 0, newStack, 0, this.size);
        }
        int i = 0;
        while (i < newStack.length) {
            newStack[i] = this.newInstance();
            ++i;
        }
        this.stack = newStack;
        this.size = newStack.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack(this.size * 2);
        }
        return this.stack[this.index++];
    }

    @Override
    public final void push(E argObject) {
        assert (this.index > 0);
        this.stack[--this.index] = argObject;
    }

    protected abstract E newInstance();

    protected abstract E[] newArray(int var1);
}

